<?php
/**
 * Moderation Auto-PM
 * Automaticly sends a PM when a thread, post or attachment is moderated
 */

/**
 * Handles the checks to see if the PM should be sent
 * 
 * @package 	mod_autopm
 * @version 	2.0.1
 * @author 		Alan Wagstaff
 * @copyright 	(C) 2006 Alan Wagstaff
 */

class autopm_checker
{
	
	/**
	 * An array of valid actions
	 * 
	 * @var 	array
	 */
	var $actions = array('delete',
						 'undelete',
						 'open',
						 'close',
						 'approve',
						 'unapprove',
						 'stick',
						 'unstick',
						 'move',
						 'merge',
						 'edit_title',
						 'ajax_edit'
						);

	/**
	 * The moderation action being performed
	 * 
	 * @var 	char
	 */
	var $action = "";

	/**
	 * Type (thread, post, attachment)
	 * 
	 * @var 	char
	 */
	var $type = "";

	/**
	 * The list of forums to exclude
	 * 
	 * @var		mixed
	 */
	var $exclude = false;

	/**
	 * A reference to the vBulletin object
	 * 
	 * @var 	object
	 */
	var $vbulletin = null;

	/**
	 * Constructor - sets up the vBulletin object, fetches the exclude list and fills in vars above
	 *
	 * @param 	object	The vBulletin object
	 * @param 	char	Moderation action
	 * @param 	char	Type
	 *
	 * @return 	bool
	 */
	function autopm_checker(&$vbobj, $action = "", $type = "")
	{

		$this->vbulletin =& $vbobj;

		// Fetch exclude list
		if ($this->vbulletin->options['cit_autopm_exclude'] != '')
		{
			$this->exclude = explode(",", $this->vbulletin->options['cit_autopm_exclude']);
		}

		// Chekc the action is valid and set it
		if (in_array($action, $this->actions))
		{
			$this->action = $action;
		}
		else 
		{
			return false;
		}

		// Type
		if (($type == 'thread') OR ($type == 'post') OR ($type == 'attachment'))
		{
			$this->type = $type;
		}
		else
		{
			return false;
		}

	}

	/**
	 * Checks if we should send a PM for the specified action
	 *
	 * @return 	bool
	 */
	function check_send_status()
	{

		// Is the PM system enabled?
		if (!$this->vbulletin->options['enablepms'])
		{
			return false;
		}

		// Check autopm options for the type/action
		if (!$this->vbulletin->options['cit_autopm_' . $this->type . '_' . $this->action])
		{
			return false;
		}

		// If we get this far then it's all good
		return true;

	}

}

?>